/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.PropDefEditorShell;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.PropDefEditorShell;
import org.apache.commons.io.FilenameUtils;

public class PropDefEditorShellController {
    private String fullName;
    private JTextPane textPane;
    private boolean modified;
    private Language lan;
    private PropDefEditorShell shell;
    private FindReplaceDialog findReplaceDialog;

    public PropDefEditorShellController(JTextPane textPane, PropDefEditorShell shell) {
        this.textPane = textPane;
        this.shell = shell;
        this.findReplaceDialog = null;
    }

    private boolean checkHeader() {
        Document document = this.textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() == 0) {
            return false;
        }
        block9: for (int i = 0; i < 5; ++i) {
            String lineText;
            Element lineElem = rootElem.getElement(i);
            if (lineElem == null) {
                return false;
            }
            int lineStart = lineElem.getStartOffset();
            int lineEnd = lineElem.getEndOffset();
            try {
                lineText = document.getText(lineStart, lineEnd - lineStart).trim();
            }
            catch (BadLocationException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return false;
            }
            switch (i) {
                case 0: {
                    if (lineText.equals("# NooJ V1") || lineText.equals("# NooJ V2") || lineText.equals("# NooJ V3") || lineText.equals("# NooJ V4")) continue block9;
                    return false;
                }
                case 1: {
                    if (lineText.equals("# Dictionary properties' definition")) continue block9;
                    return false;
                }
                case 2: {
                    if (lineText.equals("#")) continue block9;
                    return false;
                }
                case 3: {
                    if (lineText.substring(0, 15).equals("# Language is: ")) continue block9;
                    return false;
                }
                case 4: {
                    if (lineText.equals("#")) continue block9;
                    return false;
                }
            }
        }
        return true;
    }

    private String getLanguage() {
        String lineText;
        Document document = this.textPane.getDocument();
        Element rootElem = document.getDefaultRootElement();
        if (rootElem.getElementCount() < 5) {
            return null;
        }
        Element lineElem = rootElem.getElement(3);
        if (lineElem == null) {
            return null;
        }
        int lineStart = lineElem.getStartOffset();
        int lineEnd = lineElem.getEndOffset();
        try {
            lineText = document.getText(lineStart, lineEnd - lineStart).trim();
        }
        catch (BadLocationException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
            return null;
        }
        if (lineText.length() < 16) {
            return null;
        }
        return lineText.substring(15);
    }

    public boolean loadFromFile(String fn) {
        this.fullName = fn;
        BufferedReader sr = null;
        StringBuilder builder = null;
        try {
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fn), "UTF8"));
        }
        catch (FileNotFoundException e) {
            if (fn.equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Filename cannot be empty!", "NooJ", 1);
            } else {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File \"" + fn + "\" not found!", "NooJ", 1);
            }
            return false;
        }
        catch (UnsupportedEncodingException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while encoding! Unsupported encoding!", 0);
        }
        try {
            builder = new StringBuilder();
            String line0 = sr.readLine();
            while (line0 != null) {
                builder.append(line0);
                builder.append("\n");
                line0 = sr.readLine();
            }
            this.textPane.setText(builder.toString());
            sr.close();
        }
        catch (IOException e) {
            try {
                sr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "NooJ: Cannot load file " + fn, "NooJ", 1);
            return false;
        }
        if (!this.checkHeader()) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Dictionary properties' definitions format error", "NooJ: Header for .def file is invalid", 1);
            this.textPane.setText("");
            return false;
        }
        this.lan = new Language(this.getLanguage());
        if (this.lan == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot process language in file " + fn, "NooJ: Header for .def file is invalid", 1);
            return false;
        }
        this.modified = false;
        this.shell.setTitle(FilenameUtils.getName(this.fullName));
        this.textPane.setCaretPosition(0);
        return true;
    }

    public void saveDicoDef() {
        if (this.fullName == null) {
            this.saveAsDicoDef();
        } else {
            try {
                CursorChangeEffect.setCustomCursor(3);
                this.save();
            }
            finally {
                CursorChangeEffect.setCustomCursor(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDicoDefForNooJ() {
        String languagename = this.lan.isoName;
        String dirname = FilenameUtils.concat(FilenameUtils.concat(Paths.applicationDir, "resources"), FilenameUtils.concat("initial", FilenameUtils.concat(languagename, "Lexical Analysis")));
        String fname = FilenameUtils.getName(this.fullName);
        String noojname = FilenameUtils.concat(dirname, fname);
        try {
            CursorChangeEffect.setCustomCursor(3);
            this.save(noojname, true);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "File " + noojname + " has been updated.", "NooJ Update", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsDicoDef() {
        File directory = new File(FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.lan.isoName, "Lexical Analysis")));
        JFileChooser chooser = Launcher.getSaveDefDialogChooser();
        chooser.setCurrentDirectory(directory);
        if (chooser.showSaveDialog(this.shell) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        Launcher.getOpenDicChooser().setCurrentDirectory(file);
        Launcher.getSaveDicChooser().setCurrentDirectory(file);
        Launcher.getOpenDefDialogChooser().setCurrentDirectory(file);
        chooser.setCurrentDirectory(file);
        String fileStr = file.getAbsolutePath();
        if (!fileStr.endsWith(".def")) {
            fileStr = fileStr + ".def";
        }
        try {
            CursorChangeEffect.setCustomCursor(3);
            this.save(fileStr, false);
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }

    public boolean save() {
        if (this.fullName == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot save dictionary's properties' definitions", "NooJ: undefined file name", 1);
            return false;
        }
        this.save(this.fullName, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String fullname, boolean forNooJ) {
        String fname;
        if (!forNooJ && (fname = FilenameUtils.getName(fullname)).charAt(0) == '_' && JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "WARNING: file name starts with \"_\". Are you sure you want to save it with this prefix?", "NooJ: protected resource", 0) != 0) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullname), "UTF8"));
            writer.write(this.textPane.getText());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "NooJ: cannot save dictionary properties' definitions", "NooJ", 0);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (!forNooJ) {
            this.fullName = fullname;
        }
        this.modified = false;
        this.shell.setTitle(FilenameUtils.getName(this.fullName));
    }

    public void initLoad(String language) {
        StringBuilder builder = new StringBuilder();
        builder.append("# NooJ V4\n");
        builder.append("# Dictionary properties' definition\n");
        builder.append("#\n");
        builder.append("# Language is: " + language + "\n");
        builder.append("#\n");
        builder.append("# Special Characters: '=' '+' '#' ' '\n");
        builder.append("#\n");
        builder.append("# Starting with V3, there is only ONE Dictionary Properties' Definition File per language;\n");
        builder.append("# it should always be named _properties.def and be saved in the \"Lexical Analysis\" folder\n");
        builder.append("#\n");
        builder.append("# List categories and properties associated with features\n");
        builder.append("#   Example: N_Number = m + f;\n");
        builder.append("# Special KEYWORD: INFLECTION lists all inflectional features (used by variables $xF)\n");
        builder.append("#   Example: INFLECTION = m + f + Present + Futur;\n");
        this.textPane.setText(builder.toString());
        this.lan = new Language(language);
    }

    public void modify() {
        if (this.modified) {
            return;
        }
        this.modified = true;
        if (this.fullName == null) {
            this.shell.setTitle("Untitled [Modified]");
        } else {
            this.shell.setTitle(FilenameUtils.getName(this.fullName) + " [Modified]");
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public FindReplaceDialog getFindReplaceDialog() {
        return this.findReplaceDialog;
    }

    public void setFindReplaceDialog(FindReplaceDialog findReplaceDialog) {
        this.findReplaceDialog = findReplaceDialog;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void close() {
        if (this.findReplaceDialog != null) {
            this.findReplaceDialog.dispose();
            this.setFindReplaceDialog(null);
        }
        if (this.modified && Launcher.projectMode) {
            int code = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "Save inflectional description file?", "NooJ: properties' description file has not been not saved", 1);
            if (code == 2) {
                return;
            }
            if (code == 0) {
                this.saveDicoDef();
            }
        }
        this.shell.dispose();
    }

    public Language getLan() {
        return this.lan;
    }
}

